//**********Implementation file of header 6_16.h *********************/
// Author      : Oren Garten	
// Modify Date : 26/06/09				 
// Project     : 6_16
// Using       : iostream
//
// Description : Implementation of Question 6_16

/************** Library Includes *************/
#include <iostream>
#include "6_16.h"
//----------------------------------------------

int max(int a, int b)
{
	
	//one is pos, other is neg
	if(is_negative(a)&& !is_negative(b))
		return b;
	else if(is_negative(b)&&!is_negative(a))
		return a;

	else//both have the same sign
		return bigger(a,b);		

}

//---------------------------------

bool is_negative(int a)
{
	
	//look at sign bit, i.e MSB of the integer
	return ((1<<NUMofDIGITS-1)&a);
}

//---------------------------------
int bigger(int a, int b)
{
	//Let's look for example at a 3bit two's complement table:
	
	//0111 7
	//0110 6
	//0101 5
	//0100 4
	//0011 3
	//0010 2
	//0001 1
	//0000 0
	//1111 -1
	//1110 -2
	//1101 -3
	//1100 -4
	//1011 -5
	//1010 -6
	//1001 -7
	//1000 -8
	

	//We can see that for a pair of numbers with equal sign we
	//can scan the digits from MSB to LSB untill we find a difference in one bit.
	//the number having that bit with '1' is the bigger one.
	
	int xor_temp = a^b;
	int diffBit=1<<NUMofDIGITS-2;//_|-|______ start scanning from first bit right to sign bit
	//note: if we start scanning from first bit(i.e sign bit): shifting right the mask 
	//will duplicate the sign bit(and in case it's negative, will add one's to the left).
	//(It does so, in order to produce division by 2 in Two's complement display), consequently  
	//the mask's pattern that must be always "one hot" will get damaged...
	
	if(0 == xor_temp) //equal numbers
		return a;
	else
	{
		//keep on scanning digits from left to right as long as no diff present
		while(0 == (diffBit & xor_temp))
			diffBit >>=1;

		if(diffBit&a)//a's bit is 1, b's bit is 0 
				return a;
			else
				return b;//a's bit is 0, b's bit is 1
	}
}
//---------------------------------
//Another implementation....
int bigger2(int a, int b)
{
	
	int i,j ;

	for(i=0, j=1<<(NUMofDIGITS-2); i< NUMofDIGITS-1 ; i++)
	{
		if((a&j) != (b&j))
			break;
		else
			j>>=1;
	}
	
	if(i == NUMofDIGITS -1 )//a and b are equal
		return a;
	else
	{
		if(j&a)//a's bit is 1, b's bit is 0 
			return a;
		else
			return b;//a's bit is 0, b's bit is 1 
	}	

}
//---------------------------------
