/**************** File Main of 6_4  ***************/
// Author      : Oren Garten	
/* Modify Date : 10/08/09				 
// Project     : 6_4
// Using       : iostream, assert.h, ctime 
// Description : Implementation of Question 6_4 



/************** Library Includes *************/
#include <iostream>
#include <assert.h>
#include <ctime> //for rand()

#define  MAX_ARR_SIZE 4

typedef  unsigned int   Uint; 
typedef  unsigned short Ushort; 
typedef  unsigned char  Uchar; 


/**************** Declarations ***************/

//---------------------------------
// Function    : ReverseNum
// Description : Reverses a number so that MSBs become LSBs and vice-versa.   
//				Complexity- Time:O(n^2) Memory:O(1), where n is the number of bits.
//				 
// Input       : a -num to be reversed
//				 
// Returns     : Uchar - the reversed result

Uchar ReverseNum(Uchar a)
{

	Uchar temp,res =0 ;
	Uchar mask = 1;
	int i;

	//scan original num from LSB to MSB(right to left), and put the ith bit  
	//in the (7-i)th index of the result register. 
	for(i =0; i<8*sizeof(Uchar); i++)
	{
		if( a & mask)
		{
			temp = 1 <<(7-i);
			res |= temp;
		}
		mask <<=1;
	}
	
	return res;

}

//---------------------------------
// Function    : ReverseNum2 //a more economical  solution
// Description :Reverses a number so that MSBs become LSBs and vice-versa.  
//				Complexity- Time:O(n) Memory:O(1), where n is the number of bits.
//				 
// Input       : a -num to be reversed
//				 
// Returns     : Uchar - the reversed result

Uchar ReverseNum2(Uchar a)
{

	int mask_trg = 0x80;  //|-|_________
	Uchar mask_src = 0x1; //|_________|-| 
	
	//Note: mask_trg is deliberately of a type bigger than the possible max value
	//(type int and not Uchar) bacause we want to make sure that at val 0x80 its MSB == 0.
	//Now it can be shifted right >> without duplicating '1's to its left...

	int i;
	Uchar res =0 ;//res is the accumulator so must be initialized to zero!


	//scan original num from LSB to MSB(right to left)
	//scan result register from MSB to LSB left to right
	for(i =0; i<8*sizeof(Uchar); i++)
	{
		if( a & mask_src)
		{
			res = res & (~mask_trg);//res AND |---|_|---| results in: |**old**|_|***|
			res |= mask_trg;
		}
		
		//here lies the optimization: instead of the previous (7-i) shifts, 
		//do only a single shift! (price is another mask for the target, 
		//shifting the opposite way)
		mask_trg >>= 1;//go right
		mask_src <<=1;//go left
	}
	
	return res;

}

//---------------------------------


int main()
{
	Uchar num1 =0xab;
	
	printf("reverse of 0x%02x is 0x%02x\n", num1, ReverseNum(num1));
	
	//a more economical  solution
	printf("reverse2 of 0x%02x is 0x%02x\n", num1, ReverseNum2(num1));
	
	return 0;
}