/**************** File Main of MaximalFunc  ***************/
// Author      : Oren Garten	
// Modify Date : 10/08/09				 
// Project     : MaximalFunc
// Using       : iostream,assert.h,ctime 
// Description : Implementation of Question MaximalFunc 



/************** Library Includes *************/
#include <iostream>
#include <assert.h>
#include<ctime> //for rand()
#include<cmath> //for pow(

#define  MAX_SIZE 3
typedef double(*func_t)(double);

/**************** Declarations ***************/
// Struct      : 
// Description : 
// Fields      : next - pointer to the next node in the list
//				 data - the life points of the Enemy




//---------------------------------
// Function    : f0(x) //linear
// Description : 7x+1 
//				 
// Input       :  - 
//				 
// Returns     : double - 

double f0 (double x)
{
	return (7*x +1);
}
//---------------------------------
// Function    : f1(x) //square
// Description : x^2 +2x +6;  
//				 
// Input       :  - 
//				 
// Returns     : double - 

double f1 (double x)
{
	return (pow(x,2)+2*x +6);
}
//---------------------------------
// Function    : f2(x) //triple
// Description : x^3 +5x+ 1 
//				 
// Input       :  - 
//				 
// Returns     : double - 

double f2 (double x)
{
	return (pow(x,3)+5*x +1);
}
//---------------------------------
// Function    : max_of_funcs
// Description : Given two pointers to functions and a value x, returns max(f(x),g(x)) 
//				 
// Input       :  - 
//				 
// Returns     : double - 

double max_of_funcs(func_t f , func_t g, double x)
{
	double f_val = f(x);
	double g_val = g(x);
	
	return((f_val > g_val)? f_val: g_val);
 }
//---------------------------------
// Function    : func_t MaxiamlFunc
// Description : Given an array of functions and a value c, returns the fi() which 
//				 produces the biggest f(c) of all functions. 
//				 
// Input       :  - 
//				 
// Returns     : double - 

func_t MaxiamlFunc(func_t func[MAX_SIZE], double c)
{
	int max_idx =0;
	int max_val = func[0](c);
	int current_val;
	
	 for (int i = 1; i< MAX_SIZE ; i++)
	 {
		 current_val = func[i](c);
		 if(current_val > max_val)
		 {
			max_val	= current_val;
			max_idx = i;
		 }
	 }
	 
	 return func[max_idx];
}

//---------------------------------
int main()
{
	
	system("cls"); 
    srand(time(0));

	func_t arr[MAX_SIZE] ; 
	//initialize the array with functions...
	arr[0] = f0;
	arr[1] = f1;
	arr[2] = f2;

	
	//seif A
	printf("max value among two functions for x = %06.2lf is %06.2lf\n",2.1, max_of_funcs(f0, f2, 2.1)); 
	
	//seif B
	//func_t some_func;
	//some_func = MaxiamlFunc(arr,-3.0);
	
	printf("max value fi(%06.2lf) among functions is: %06.2lf\n",-3.0, MaxiamlFunc(arr,-3.0)(-3.0));  


	return 0;
}