/**************** File Main of SortByFunc  ***************/
// Author      : Oren Garten	
// Modify Date : 10/08/09				 
// Project     : SortByFunc
// Using       : iostream,assert.h,ctime 
// Description : Implementation of Question SortByFunc 



/************** Library Includes *************/
#include <iostream>
#include <assert.h>
#include<ctime> //for rand()
#include<cmath> //for fabs()
#include<algorithm>//for swap()

using namespace std;

#define  MAX_SIZE 10

typedef bool(*fcomp)(double, double);

/**************** Declarations ***************/
// Struct      : 
// Description : 
// Fields      : next - pointer to the next node in the list
//				 data - the life points of the Enemy


//---------------------------------
// Function    : bigger  
// Description : 
//				 
// Input       :  - 
//				 
// Returns     : bool - 

bool bigger(double x, double y)
{
	return ( x > y);
}
//---------------------------------
// Function    : bigger_abs ; 
// Description : 
//				 
// Input       :  - 
//				 
// Returns     : bool - 

bool bigger_abs(double x, double y)
{
	return ( fabs(x) > fabs(y));
}

//---------------------------------
// Function    : smaller ; 
// Description : 
//				 
// Input       :  - 
//				 
// Returns     : bool - 

bool smaller(double x, double y)
{
	return ( x < y);
}

//---------------------------------
// Function    : sortByFunc
// Description : receives an array of integers and some comparing function. 
//				 sortByFunc() will sort the array according to the sorting function.
//				 complexity: bubble sort- Time O(n^2).Memory O(1).
//				 
// Input       :  - 
//				 
// Returns     : void - 

void sortByFunc(double arr[MAX_SIZE],fcomp comp)
{
	for(int i= MAX_SIZE -1 ; i>=0 ; i--)
	{
		for(int j=1; j<= i ; j++)
		{
			if( comp(arr[j-1], arr[j]) )
				swap(arr[j],arr[j-1]);
		}
	}
}
//-------------------------------------------

// Function    : initArr
// Description : initialize an array with randomal values in the range ~[-100:100]
//				 
// Input       :  - 
//				 
// Returns     : void - 

void initArr(double arr[MAX_SIZE])
{
	for(int i=0; i< MAX_SIZE ; i++)
	{
		//range[-100:100]
		if (rand()%2) 
			arr[i] = -((rand()%201)/2.11);//negatives 
		else
			arr[i] = (rand()%201)/2.11;//positives
	}	
}
//---------------------------------
// Function    : dispArr
// Description : display array's elements on screen
//				 
// Input       :  - 
//				 
// Returns     : void - 

void dispArr(double arr[MAX_SIZE])
{
	for(int i=0; i< MAX_SIZE ; i++)
		printf("%05.2lf ",arr[i]);
	printf("\n");
}

//---------------------------------
int main()
{
	
	system("cls"); 
    srand(time(0));

	double arr[MAX_SIZE] ; 
	
	//initialize the array with random values[-100:100]...
	initArr(arr);
	printf("\n\nInitial order:\n");
	dispArr(arr);

	//sorting using smaller
	printf("\n\nsorting in Descending order:\n");
	sortByFunc(arr, smaller);
	dispArr(arr);

	//sorting using bigger
	printf("\n\nsorting in Ascending order:\n");
	sortByFunc(arr, bigger);
	dispArr(arr);

	//sorting using bigger_abs
	printf("\n\nsorting in Ascending order, absolute values:\n");
	sortByFunc(arr, bigger_abs);
	dispArr(arr);

	
	

	return 0;
}




/*
// Function    : sortByFunc
// Description : 
//				 
// Input       :  - 
//				 
// Returns     : double - 
//------------------------------------------------
void sortByFunc(double arr[MAX_SIZE])
{
	
	for(int i= MAX_SIZE -1 ; i>=0 ; i--)
		for(int j=1; j<= i ; j++)
		{
			if(arr[j-1]>arr[j])
				swap(arr[j],arr[j-1]);
		}

}
//---------------------------------*/